const mysql = require("mysql2/promise");
const axios = require("axios");
const cron = require("node-cron");
const env = require("dotenv").config();
const moment = require("moment-timezone");

let timenow = moment().tz("Asia/Kolkata").format("HH:mm:ss");
let day = moment().tz("Asia/Kolkata").format("dddd");
console.log(timenow, day);
if (
  timenow >= "09:15:00" &&
  timenow <= "15:29:59" &&
  day !== "Saturday" &&
  day !== "Sunday"
) {
  // Database connection settings
  const dbConfig = {
    host: process.env.DB_HOST || "localhost",
    user: process.env.DB_USER || "your_db_username",
    password: process.env.DB_PASSWORD || "your_db_password",
    database: process.env.DB_NAME || "your_db_name",
  };

  const securityID = 13;
  const segment = "IDX_I";
  const idx = "NIFTY50";

  async function main() {
    const expiry = await fetchExpiryDates();
    const optionData = await fetchOptionData(expiry);
    await saveData(expiry, optionData);
  }

  async function fetchExpiryDates() {
    const uri = `https://api.dhan.co/v2/optionchain/expirylist`;
    const data = {
      UnderlyingScrip: securityID,
      UnderlyingSeg: segment,
    };

    const headers = {
      "Content-Type": "application/json",
      "access-token": process.env.ACCESS_TOKEN || "",
      "client-id": process.env.CLIENT_ID || "",
    };

    try {
      const result = await axios.post(uri, data, { headers });
      const datax = await result.data;
      return datax.data[0];
    } catch (error) {
      console.error("Error fetching expiry list:", error.message);
    }
  }

  async function fetchOptionData(props) {
    const uri = `https://api.dhan.co/v2/optionchain`;
    const expiry = props;
    try {
      const result = await axios.post(
        uri,
        {
          UnderlyingScrip: securityID,
          UnderlyingSeg: segment,
          Expiry: expiry,
        },
        {
          headers: {
            "Content-Type": "application/json",
            "access-token": process.env.ACCESS_TOKEN || "",
            "client-id": process.env.CLIENT_ID || "",
          },
        }
      );

      const datax = result.data;
      const atm = Math.round(datax.data.last_price / 50) * 50;
      const minStrike = atm - 300;
      const maxStrike = atm + 300;
      const tabData = datax.data.oc;
      let i = 0;
      for (let strike in tabData) {
        const numericStrike = parseInt(strike);
        if (numericStrike >= minStrike && numericStrike <= maxStrike) {
          const newObj = {
            expiry: expiry,
            strike: numericStrike,
            data: tabData[strike],
          };
          // console.log(newObj);
          return newObj;
        }
      }
    } catch (error) {
      console.error("Error fetching option data:", error.message);
    }
  }

  async function saveData(expiry, optionData) {
    // 1. Prepare data
    // console.log(expiry, optionData);
    const expirydt = expiry;
    const current = new Date().toISOString().split("T")[0];
    const data = optionData;
    try {
      // 2. Connect to database
      const connection = await mysql.createConnection(dbConfig);
      await connection.execute(
        "INSERT INTO optiondata (idx, expiry, current , data ) VALUES (?, ?, ?, ?)",
        [idx, expirydt, current, JSON.stringify(data)],
        (err, result) => {
          if (err) throw err;
          console.log("Data inserted successfully");
        }
      );

      await connection.end();
      console.log("DB operation success:", new Date());
    } catch (error) {
      console.error("Error:", error.message);
    }
  }

  // Schedule to run every 5 minutes
  cron.schedule("*/1 * * * *", main);

  // Initial fetch on server start
  main();
  // // Optional: Keep the process alive (for cPanel/Node.js app)
  setInterval(() => {}, 1000);
} else {
  console.log("Outside trading hours!");
}
